

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0 text-gray-800">Result Details</h1>
            <a href="<?php echo e(route('admin.results.index')); ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to List
            </a>
        </div>

        <div class="row">
            <!-- Student & Exam Info -->
            <div class="col-md-4 mb-4">
                <div class="card shadow h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Candidate Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="text-muted small text-uppercase">Student Name</label>
                            <div class="fw-bold fs-5"><?php echo e($attempt->user->name); ?></div>
                        </div>
                        <div class="mb-3">
                            <label class="text-muted small text-uppercase">Email</label>
                            <div><?php echo e($attempt->user->email); ?></div>
                        </div>
                        <hr>
                        <div class="mb-3">
                            <label class="text-muted small text-uppercase">Exam Title</label>
                            <div class="fw-bold"><?php echo e($attempt->exam->title); ?></div>
                        </div>
                        <div class="mb-3">
                            <label class="text-muted small text-uppercase">Submission Time</label>
                            <div><?php echo e($attempt->updated_at->format('M d, Y h:i A')); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Score Info -->
            <div class="col-md-8 mb-4">
                <div class="card shadow h-100 border-start border-5 border-primary">
                    <div class="card-body d-flex align-items-center justify-content-center text-center p-5">
                        <div>
                            <div class="text-uppercase text-muted letter-spacing-2 mb-2">Total Score</div>
                            <h1 class="display-1 fw-bold text-primary mb-0"><?php echo e($attempt->score); ?></h1>
                            <div class="fs-4 text-muted">out of <?php echo e($attempt->exam->total_marks); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Question Analysis -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 fw-bold text-primary">Answer Analysis</h6>
            </div>
            <div class="card-body">
                <?php $__currentLoopData = $attempt->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border rounded p-3 mb-3 <?php echo e($answer->is_correct ? 'border-success bg-success-subtle' : 'border-danger bg-danger-subtle'); ?>"
                        style="--bs-bg-opacity: .05;">
                        <div class="d-flex justify-content-between">
                            <h6 class="fw-bold">Q<?php echo e($index + 1); ?>. <?php echo e($answer->question->question_text); ?></h6>
                            <span class="badge <?php echo e($answer->is_correct ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e($answer->is_correct ? 'Correct' : 'Incorrect'); ?>

                            </span>
                        </div>

                        <div class="mt-2 ms-3">
                            <?php $__currentLoopData = $answer->question->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $isSelected = is_array($answer->selected_options) && in_array($option->id, $answer->selected_options);
                                    $isCorrect = $option->is_correct;

                                    $class = "text-muted";
                                    $icon = "bi bi-circle";

                                    if ($isCorrect) {
                                        $class = "text-success fw-bold";
                                        $icon = "bi bi-check-circle-fill";
                                    } elseif ($isSelected) {
                                        $class = "text-danger fw-bold";
                                        $icon = "bi bi-x-circle-fill";
                                    }
                                ?>
                                <div class="<?php echo e($class); ?> mb-1">
                                    <i class="<?php echo e($icon); ?> me-2"></i> <?php echo e($option->option_text); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/results/show.blade.php ENDPATH**/ ?>