<?php $__env->startSection('content'); ?>
<div class="container mt-5 course-details-page">
    <div class="row">
        <div class="col-lg-8">
            <h1 class="course-title"><?php echo e($course->title); ?></h1>
            <p class="admission-status"><i class="fas fa-fire"></i> ভর্তি চলছে...</p>
            <img src="<?php echo e(asset($course->image)); ?>" alt="<?php echo e($course->title); ?>" class="course-image">

            <ul class="nav nav-tabs" id="courseTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="description-tab" data-toggle="tab" href="#description" role="tab" aria-controls="description" aria-selected="true">Overview</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="instructors-tab" data-toggle="tab" href="#instructors" role="tab" aria-controls="instructors" aria-selected="false">Instructor</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="routine-tab" data-toggle="tab" href="#routine" role="tab" aria-controls="routine" aria-selected="false">Routine</a>
                </li>
            </ul>
            <div class="tab-content" id="courseTabContent">
                <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="description-tab">
                    <?php echo $course->description; ?>

                </div>
                <div class="tab-pane fade" id="instructors" role="tabpanel" aria-labelledby="instructors-tab">
                    <ul>
                        <?php $__currentLoopData = json_decode($course->instructors, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($instructor); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="tab-pane fade" id="routine" role="tabpanel" aria-labelledby="routine-tab">
                    <?php echo $course->routine; ?>

                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="course-features-box">
                <div class="price-section">
                    <?php if($course->discount_amount): ?>
                        <span class="current-price">৳ <?php echo e($course->discount_amount); ?></span>
                        <span class="original-price">৳ <?php echo e($course->real_amount); ?></span>
                    <?php else: ?>
                        <span class="current-price">৳ <?php echo e($course->real_amount); ?></span>
                    <?php endif; ?>
                </div>
                <?php if($course->offer_expire_date): ?>
                    <div class="offer-countdown">
                        <i class="fas fa-clock"></i> <?php echo e(\Carbon\Carbon::parse($course->offer_expire_date)->diffForHumans()); ?> left at this price!
                    </div>
                <?php endif; ?>
                <ul class="feature-list">
                    <li>
                        <span><i class="fas fa-clock"></i> Course Duration</span>
                        <strong><?php echo e($course->course_duration); ?></strong>
                    </li>
                    <li>
                        <span><i class="fas fa-video"></i> Total Lecture</span>
                        <strong><?php echo e($course->total_lecture); ?></strong>
                    </li>
                    <li>
                        <span><i class="fas fa-file-alt"></i> Total Exam</span>
                        <strong><?php echo e($course->total_exam); ?></strong>
                    </li>
                    <li>
                        <span><i class="fas fa-chalkboard-teacher"></i> Live class</span>
                        <strong><?php echo e($course->live_class); ?></strong>
                    </li>
                </ul>
                <a href="#" class="btn btn-primary btn-lg btn-block">কোর্সটি কিনুন</a>
                <div class="includes-section">
                    <h5>This Course includes:</h5>
                    <ul class="includes-list">
                        <?php $__currentLoopData = json_decode($course->course_includes, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="fas fa-check-circle"></i> <?php echo e($item); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="contact-section">
                    <h5>কোর্সটি সম্পর্কে বিস্তারিত জানতে কল করুন</h5>
                    <a href="tel:09644433300" class="h4 text-danger">📞 09644433300</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\turningpoint\resources\views/frontend/courses/show.blade.php ENDPATH**/ ?>