<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <div class="header-title">
                    <h4 class="card-title">All Branches</h4>
                </div>
                <div class="header-action">
                    <a href="<?php echo e(route('admin.branches.create')); ?>" class="btn btn-primary">Add Branch</a>
                </div>
            </div>
            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Logo</th>
                                <th>Slug</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($branch->name); ?></td>
                                    <td>
                                        <?php if($branch->logo): ?>
                                            <img src="<?php echo e(asset($branch->logo)); ?>" alt="<?php echo e($branch->name); ?>" width="50">
                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($branch->slug); ?></td>
                                    <td>
                                        <div class="d-flex">
                                            <a href="<?php echo e(route('admin.branches.edit', $branch->id)); ?>" class="btn btn-sm btn-info mr-2">Edit</a>
                                            <form action="<?php echo e(route('admin.branches.destroy', $branch->id)); ?>" method="POST" onsubmit="return confirm('Are you sure?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\turningpoint\resources\views/admin/branches/index.blade.php ENDPATH**/ ?>