<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2 class="section-title text-center"><?php echo e($category->name); ?> - All Courses</h2>
    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-4 mb-4">
                <div class="course-card">
                    <div class="img-container">
                        <img src="<?php echo e(asset($course->image)); ?>" alt="<?php echo e($course->title); ?>">
                        <div class="course-fee">
                            <?php if($course->discount_amount): ?>
                                <del>৳ <?php echo e($course->real_amount); ?></del> ৳ <?php echo e($course->discount_amount); ?>

                            <?php else: ?>
                                ৳ <?php echo e($course->real_amount); ?>

                            <?php endif; ?>
                        </div>
                        <a href="<?php echo e(route('frontend.courses.show_detail', $course->id)); ?>" class="view-details-hover">
                            <span class="btn btn-light">View Details</span>
                        </a>
                    </div>
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($course->title); ?></h5>
                        <div class="course-info">
                            <div class="info-item">
                                <i class="fas fa-video"></i>
                                <span><?php echo e($course->total_lecture); ?> Classes</span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-file-alt"></i>
                                <span><?php echo e($course->total_exam); ?> Exams</span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-book"></i>
                                <span>PDFs</span>
                            </div>
                        </div>
                        <a href="<?php echo e(route('frontend.courses.show_detail', $course->id)); ?>" class="btn btn-primary btn-block">বিস্তারিত দেখুন</a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12 text-center">
                <p>No courses available for this category.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\turningpoint\resources\views/frontend/category_courses/index.blade.php ENDPATH**/ ?>